#ifndef HDGL_H
#define HDGL_H

#include <stdint.h>

#define MAX_CHANNELS 64
#define PAGE_SIZE 4096

typedef struct {
    uint8_t buffer[PAGE_SIZE];
    uint8_t active;
    char name[32];
} HDGL_Channel;

typedef struct {
    HDGL_Channel channels[MAX_CHANNELS];
    int num_channels;
} HDGL_Lattice;

// Initialize lattice channels
void hdgl_init(HDGL_Lattice *lattice);

// Map kernel/initramfs bytes into channels
void hdgl_map_bytes(HDGL_Lattice *lattice, uint8_t *data, int len, const char *device_name);

// Operate on all channels (live)
void hdgl_execute_all(HDGL_Lattice *lattice);

// Harmonic fusion
void hdgl_fuse_channels(HDGL_Lattice *lattice);

#endif
